/*
 * Decompiled with CFR 0.152.
 */
package com.rovio.rtool.mobile.ui;

import com.rovio.rtool.mobile.CanvasController;
import com.rovio.rtool.mobile.Core;
import com.rovio.rtool.mobile.Resources;
import com.rovio.rtool.mobile.ui.ContentItem;
import javax.microedition.lcdui.Graphics;

public class SplashScreen
extends CanvasController {
    private int m_currentTime = 0;
    private boolean m_needsRepaint = true;
    private boolean m_showLoadingBar = false;
    private int m_loadingBarMaxValue = 100;
    private int m_loadingBarValue = 0;
    private int m_loadingBarAutoIncrement = 1;
    private int m_loadingBarStartTime;
    private static final int DEFAULT_LOADING_BAR_INCREMENT = 1;
    private static final int AUTO_LOADING_BAR_SCROLL_TIME = 4000;
    private int m_screenAction = -1;
    private boolean m_keyPressTriggersAction = false;
    private int m_actionTriggerTime = -1;
    public static final int ACTION_TIME_DISABLED = -1;
    private int m_sprite = -1;
    private ContentItem m_contentItem = null;
    private int m_bgColor = 0;

    private SplashScreen() {
    }

    public static SplashScreen createSplashScreen(int n) {
        SplashScreen splashScreen = new SplashScreen();
        splashScreen.m_sprite = n;
        return splashScreen;
    }

    public static SplashScreen createSplashScreen(int n, int n2) {
        SplashScreen splashScreen = new SplashScreen();
        splashScreen.m_sprite = n;
        splashScreen.m_bgColor = n2;
        return splashScreen;
    }

    public static SplashScreen createAutoLoadingBarScreen(int n) {
        SplashScreen splashScreen = new SplashScreen();
        splashScreen.m_sprite = n;
        splashScreen.m_showLoadingBar = true;
        return splashScreen;
    }

    public static SplashScreen createAutoLoadingBarScreen(int n, int n2) {
        SplashScreen splashScreen = new SplashScreen();
        splashScreen.m_sprite = n;
        splashScreen.m_showLoadingBar = true;
        splashScreen.m_bgColor = n2;
        return splashScreen;
    }

    public static SplashScreen createLoadingBarScreen(int n, int n2) {
        SplashScreen splashScreen = new SplashScreen();
        splashScreen.m_sprite = n;
        splashScreen.m_showLoadingBar = true;
        splashScreen.m_loadingBarAutoIncrement = 0;
        splashScreen.m_loadingBarMaxValue = n2;
        return splashScreen;
    }

    public static SplashScreen createLoadingBarScreen(int n, int n2, int n3) {
        SplashScreen splashScreen = new SplashScreen();
        splashScreen.m_sprite = n;
        splashScreen.m_showLoadingBar = true;
        splashScreen.m_loadingBarAutoIncrement = 0;
        splashScreen.m_loadingBarMaxValue = n2;
        splashScreen.m_bgColor = n3;
        return splashScreen;
    }

    public void setAction(int n) {
        this.m_screenAction = n;
    }

    public void setSprite(int n) {
        this.m_sprite = n;
        this.m_needsRepaint = true;
    }

    public void setBackgroundColor(int n) {
        this.m_bgColor = n;
        this.m_needsRepaint = true;
    }

    public void setLoadingBarMaxValue(int n) {
        this.m_loadingBarMaxValue = n;
    }

    public void setLoadingBarValue(int n) {
        this.m_loadingBarValue = n;
    }

    public void setKeyPressTriggersAction(boolean bl) {
        this.m_keyPressTriggersAction = bl;
    }

    public void setActionTriggerTime(int n) {
        this.m_loadingBarStartTime = this.m_currentTime = 0;
        this.m_actionTriggerTime = n;
    }

    public void setAutoLoadingBar(boolean bl) {
        this.m_loadingBarAutoIncrement = bl ? 1 : 0;
    }

    public void setText(String string) {
        this.m_contentItem = string != null ? new ContentItem(string, CanvasController.sm_screenWidth, 2) : null;
        this.m_needsRepaint = true;
    }

    public void focusChange(boolean bl) {
        this.m_loadingBarStartTime = this.m_currentTime = 0;
        this.m_needsRepaint = true;
    }

    public void keyPressed(int n) {
        if (this.m_screenAction != -1 && this.m_keyPressTriggersAction) {
            Core.postAction(this.m_screenAction, this);
        }
    }

    public void mainLoopIteration(int n) {
        this.m_currentTime += n;
        if (this.m_screenAction != -1 && this.m_actionTriggerTime != -1 && this.m_currentTime > this.m_actionTriggerTime) {
            Core.postAction(this.m_screenAction, this);
        }
        if (this.m_showLoadingBar && this.m_loadingBarAutoIncrement != 0) {
            if (this.m_currentTime - this.m_loadingBarStartTime >= 4000) {
                this.m_loadingBarStartTime = this.m_currentTime;
                this.m_loadingBarAutoIncrement = -this.m_loadingBarAutoIncrement;
            }
            this.m_loadingBarValue = this.m_loadingBarMaxValue * (this.m_currentTime - this.m_loadingBarStartTime) / 4000;
            if (this.m_loadingBarAutoIncrement < 0) {
                this.m_loadingBarValue = this.m_loadingBarMaxValue - this.m_loadingBarValue;
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        int n = -3;
        if (this.m_sprite != -1) {
            n += Resources.getSpriteAttribute(this.m_sprite, 1) + 3;
        }
        if (this.m_contentItem != null) {
            n += this.m_contentItem.m_height + 3;
        }
        if (this.m_showLoadingBar) {
            n += 11;
        }
        int n2 = 0;
        n2 = CanvasController.sm_screenHeight - n >> 1;
        if (this.m_needsRepaint) {
            graphics.setColor(this.m_bgColor);
            graphics.setClip(0, 0, CanvasController.sm_screenWidth << 1, CanvasController.sm_screenHeight << 1);
            graphics.fillRect(0, 0, CanvasController.sm_screenWidth << 1, CanvasController.sm_screenHeight << 1);
        }
        if (this.m_sprite != -1) {
            if (this.m_needsRepaint) {
                Resources.drawSprite((CanvasController.sm_screenWidth - Resources.getSpriteAttribute(this.m_sprite, 0) >> 1) + Resources.getSpriteAttribute(this.m_sprite, 2), n2 + Resources.getSpriteAttribute(this.m_sprite, 3), this.m_sprite, graphics);
            }
            n2 += Resources.getSpriteAttribute(this.m_sprite, 1) + 3;
        }
        if (this.m_contentItem != null) {
            if (this.m_needsRepaint) {
                this.m_contentItem.draw(graphics, 0, n2, 0xFFFFFF, 0);
            }
            n2 += this.m_contentItem.m_height + 3;
        }
        if (this.m_showLoadingBar) {
            int n3 = (CanvasController.sm_screenWidth >> 1) - 50;
            int n4 = ((this.m_loadingBarValue << 8) / this.m_loadingBarMaxValue * 100 >> 8) - 4;
            graphics.setClip(n3, n2, 100, 8);
            graphics.setColor(10272511);
            graphics.drawRect(n3, n2, 99, 7);
            graphics.setColor(0);
            graphics.fillRect(n3 + 1, n2 + 1, 98, 6);
            graphics.setClip(n3 + 2, n2, 96, 8);
            graphics.setColor(0xFFFFFF);
            if (this.m_loadingBarAutoIncrement != 0) {
                graphics.fillRect(n3 - 4 + n4, n2 + 2, 8, 4);
            } else {
                graphics.fillRect(n3 + 2, n2 + 2, n4, 4);
            }
        }
        this.m_needsRepaint = false;
    }
}

